<?php


class commentModule_Pro extends commentModule {
    protected $registry;

    public function __construct($registry) {
        parent::__construct($registry);
    }

    protected function pro_hook($fileid) {
        $fileid = intval($fileid);

        if ($fileid) {
            $file = $this->registry->db->query_first("
                SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
                WHERE groupid = " . intval($fileid)
            );

            $userid = $file['userid'];
			
            if ($userid != $this->registry->userinfo['userid']) {
	            $owner = $this->registry->db->query_first("
	                SELECT * FROM " . TABLE_PREFIX . "user
	                WHERE userid = " . intval($userid)
	            );
	
	            if ($owner && $file) {
	                $notifications = unserialize($owner['dbtech_downloads_comment_notifs']);
	
	                $notifications[$fileid][] = array(
	                    'username' => $this->registry->db->escape_string($this->registry->userinfo['username']),
	                    'userid' => $this->registry->userinfo['userid'],
	
	                    'fileid' => $fileid,
	                    'filename' => $this->registry->db->escape_string($file['groupname'])
	                );
	
	                $notifications = serialize($notifications);
	
	                $this->registry->db->query_write("
	                    UPDATE " . TABLE_PREFIX . "user
	                    SET
	                        dbtech_downloads_comment_notifs = '" . $notifications . "'
	
	                    WHERE userid = " . intval($userid)
	                );
	            }
            }
        }
    }
}